/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed Materials - Property of IBM                                               
* Tivoli Presentation Services                                   
*                                                                                        
* (C) Copyright IBM Corp. 2000,2003 All Rights Reserved.                            
*                                                               
* US Government Users Restricted Rights - Use, duplication or
* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
************************************************************ {COPYRIGHT-END} ***
* Change Activity on 6/27/03 version 1.10.1.2:
* @00=WCL, V3R4, 01/27/2003, JHF: Initial version
* @01=D109442, V3R4, 02/11/2003, NFE: Add DIV-based WLayer support
* @02=D110170, V3R4, 03/10/2003, JCP: Fix keyboard accessibility with tab index
* @03=D111058, V3R4, 03/12/2003, JHF: Handle position when in BIDI
* @04=D111254, V3R4, 03/17/2003, JCP: improved styles for skins
* @05=D111486, V3R4, 03/19/2003, JHF: Formatting problems when used in a jsp
* @06=D111980, V3R4, 03/26/2003, JHF: HH:MM:SS should not change for BIDI
* @07=D112993, V3R4, 06/18/2003, NFE: Check for Mozilla browser
* @09=D113660, V3R4, 06/27/2003, NFE: Fix HTTPS issue
* @10=D, V3R4, 01/19/2004, EAW: Check for Netscape >= 7.1
*******************************************************************************/

/**
 * @param secureURL URL pointing to content served using HTTPS. This URL will
 *        be used to set the src attribute of a transparent IFRAME that is used
 *        to fix bleeding of HTMLSelectElements through absolutely
 *        positioned HTMLElements in Internet Explorer. If using a secure
 *        server, this URL must be specified at the risk of experiencing
 *        "Secure/Non-Secure" warnings issued by the browser. The URL must
 *        be secure and from the same domain as the containing window/frame.
 */
function TimeChooser(id, textID, buttonID, is24hr, showSeconds, isLTR, tabIndex, secureURL) { // @08C1
    this.id = id;
    this.textID = textID;
    this.buttonID = buttonID;
    this.is24hr = is24hr;
    this.showSeconds = showSeconds;
    this.isLTR = isLTR;
    this.tabIndex = tabIndex; //@02A
    this.secureURL = ( secureURL ? secureURL : null ); // @08A1
    this.title = null;
    this.layer = null;

    // stores text
    this.text = new Array();
    // stores style sheets
    this.styleSheets = new Array();
    // stores elements by id
    this.elementsById = new Array();

    //functions
    this.showTimeChooser = TimeChooser_show;
    this.hideTimeChooser = TimeChooser_hide;
    this.setText = TimeChooser_setText;
    this.getText = TimeChooser_getText;
    this.makeId = TimeChooser_makeId;
    this.getElementById = TimeChooser_getElementById;
    this.addStyleSheet = TimeChooser_addStyleSheet;
    this.createTimeDiv = TimeChooser_createTimeDiv;
    this.parseTime = TimeChooser_parseTime;
    this.formatNumber = TimeChooser_formatNumber;
}

function TimeChooser_makeId(id, element) {
    var eid = this.id + "_" + id;
    if (element != null) {
        this.elementsById[eid] = element;
    }
    return eid;
}

function TimeChooser_getElementById(id, aDoc) {
    if (aDoc != null)
        return aDoc.getElementById(id);
    else
        return document.getElementById(id);
}


function TimeChooser_setText(textKey, textObj) {
    this.text[textKey] = textObj;
}

function TimeChooser_getText(textKey) {
    var rText = this.text[textKey];
    if (rText == null) {
        rText = textKey;
    }
    return rText;
}

function TimeChooser_addStyleSheet(css) {
    this.styleSheets[this.styleSheets.length] = css;
}

function TimeChooser_hide() {
  if (this.layer != null)
    this.layer.setVisible(false);
}

function TimeChooser_show() {
   if (this.layer == null || !this.layer.isRendered()) { // @01
      this.layer = WLayerFactory.createWLayer(this.id, self, false, true, false, this.secureURL );
      this.layer.setHTMLElement(this.createTimeDiv());
      //for (var i=0; i<this.styleSheets.length; i++)
      //  this.layer.setStyleSheet(this.styleSheets[i]);
      //this.layer.setSizeToContent(true);
      this.layer.render();
   }
   else if (this.layer != null && this.layer.isVisible()) { // @01
       this.hideTimeChooser();
       return;
   }

   var doc = null;
   /* // @01
   if (document.all) {
       var div = null;
       for (var i=0; i<document.frames.length && doc==null; i++) {
            div = document.frames[i].document.getElementById(this.makeId("timeDiv"));
            if (div != null)
                doc = div.ownerDocument;
       }
   }
   */

   var textfield = this.getElementById(this.textID, doc);
   var timevalues = this.parseTime(textfield.value);
   var posX = WUtilities.getLeft(textfield, true);
   var posY = WUtilities.getTop(textfield, true) + WUtilities.getHeight(textfield, true);

   if (!this.isLTR)
       posX -= this.layer.getDimension().getWidth() - WUtilities.getWidth(textfield);

   this.getElementById(this.makeId("hours"), doc).value = timevalues[0];
   this.getElementById(this.makeId("minutes"), doc).value = timevalues[1];
   this.getElementById(this.makeId("seconds"), doc).value = timevalues[2];
   if (!this.is24hr) {
       var ampm = this.getElementById(this.makeId("ampm"), doc);
       ampm.selectedIndex = ampm.options[1].value.toUpperCase() == timevalues[3].toUpperCase() ? 1 : 0;
   }
   this.layer.setPosition(new Position(posX, posY));
   this.layer.setVisible(true);
}

function TimeChooser_createTimeDiv() {
   var div = document.createElement("DIV");
   var hidden = document.createElement("INPUT");
   var table = document.createElement("TABLE");
   var thead = document.createElement("THEAD");
   var tbody = document.createElement("TBODY");
   var tfoot = document.createElement("TFOOT");
   var ctable = document.createElement("TABLE"); //@04A
   var cbody = document.createElement("TBODY"); //@04A
   var tr = document.createElement("TR");
   var td = document.createElement("TD");
   var nbsp = document.createElement("SPAN");
   var ok = document.createElement("INPUT");
   var cancel = document.createElement("INPUT");
   var hours = document.createElement("INPUT");
   var minutes = document.createElement("INPUT");
   var seconds = document.createElement("INPUT");
   var ampm = document.createElement("SELECT");
   var option = document.createElement("OPTION");

   div.id = this.makeId("timeDiv", div);
   // allow for dynamic sizing in Netscape <7.1 and IE @10C1
	
   if ( !WClient.isBrowserMozilla() || ( WClient.isBrowserNetscape() && !WClient.isBrowserVersion71Up()) ) //@07A1 @10C1
   {
       div.style.width = "0%";
   }

   ok.type = "button";
   ok.value = this.getText("OK");
   ok.className="wclButton";
   ok.onmouseover = TimeChooser_buttonOverHandler;
   ok.onmouseout = TimeChooser_buttonOutHandler;
   ok.onclick = TimeChooser_buttonOkHandler;
   cancel.type = "button";
   cancel.value = this.getText("CANCEL");
   cancel.className="wclButton";
   cancel.onmouseover = TimeChooser_buttonOverHandler;
   cancel.onmouseout = TimeChooser_buttonOutHandler;
   cancel.onclick = TimeChooser_buttonCancelHandler;
   hours.type = "text";
   hours.size = 2;
   hours.maxLength = 2;
   hours.className="wclTextEntry";
   hours.id = this.makeId("hours", hours);
   minutes.type = "text";
   minutes.size = 2;
   minutes.maxLength = 2;
   minutes.className="wclTextEntry";
   minutes.id = this.makeId("minutes", minutes);
   seconds.type = this.showSeconds ? "text" : "hidden";
   seconds.size = "2";
   seconds.maxLength = 2;
   seconds.className="wclTextEntry";
   seconds.id = this.makeId("seconds", seconds);
   ampm.className="wclComboBox";
   ampm.id = this.makeId("ampm", ampm);

   option.innerHTML = this.getText("AM");
   option.value = this.getText("AM");
   ampm.appendChild(option);
   option = document.createElement("OPTION");
   option.innerHTML = this.getText("PM");
   option.value = this.getText("PM");
   ampm.appendChild(option);

//   if (document.all) {           //@05
//      hours.style.height = "100%";
//      minutes.style.height = "100%";
//      seconds.style.height = "100%";
//      ok.style.height = "100%";
//      cancel.style.height = "100%";
//   }
   if (this.tabIndex != 0) { //@02A7
       ok.tabIndex = this.tabIndex;
       cancel.tabIndex = this.tabIndex;
       hours.tabIndex = this.tabIndex;
       minutes.tabIndex = this.tabIndex;
       seconds.tabIndex = this.tabIndex;
       ampm.tabIndex = this.tabIndex;
   }

   hidden.type = "hidden";
   hidden.value = this.id;
   div.appendChild(hidden);

   table.border = 0;
   table.cellSpacing = 0;
   table.cellPadding = 0;
   table.dir = this.isLTR ? "LTR" : "RTL";
   //table.width = "100%";  // @07
   table.className="wclTimeChooserBorder"; //@04C
   nbsp.innerHTML = "&nbsp;";

   div.appendChild(table);
   table.appendChild(thead);

   //@04A10
   ctable.border = 0;
   ctable.cellSpacing = 0;
   ctable.cellPadding = 0;
   ctable.dir = "LTR";    //@06C
   //ctable.width = "100%"; // @07
   ctable.className = "wclTimeChooserTimeBorder";
   tr = document.createElement("TR");
   td = document.createElement("TD");
   td.className = "wclTimeChooser";
   table.appendChild(thead);

   thead.appendChild(tr);
   tr.appendChild(td);

   //@04A7
   td.appendChild(ctable);
   ctable.appendChild(cbody);
   tr = document.createElement("TR");
   td = document.createElement("TD");
   cbody.appendChild(tr);
   tr.appendChild(td);
   td.className="wclTimeChooserTop";

   td.innerHTML = this.getText("HOURS");

   td = document.createElement("TD");
   tr.appendChild(td);
   td.innerHTML = this.getText("MINUTES");
   td.className="wclTimeChooserTop"; //@04A

   if (this.showSeconds) {
       td = document.createElement("TD");
       tr.appendChild(td);
       td.innerHTML = this.getText("SECONDS");
       td.className="wclTimeChooserTop"; //@04A
   }

   td = document.createElement("TD");
   tr.appendChild(td);
   td.innerHTML = "&nbsp;";
   td.className="wclTimeChooserTop"; //@04A

   tr = document.createElement("TR");
   td = document.createElement("TD");
   td.className="wclTimeChooserMiddle"; //@04A
   ctable.appendChild(tbody); //@04C
   tbody.appendChild(tr)
   tr.appendChild(td);
   td.appendChild(hours);

   td = document.createElement("TD");
   td.className="wclTimeChooserMiddle"; //@04A
   tr.appendChild(td);
   td.appendChild(minutes);

   if (this.showSeconds) {
       td = document.createElement("TD");
       td.className="wclTimeChooserMiddle"; //@04A
       tr.appendChild(td);
   }
   td.appendChild(seconds);

   td = document.createElement("TD");
   td.className="wclTimeChooserMiddle"; //@04A
   tr.appendChild(td);
   if (!this.is24hr)
       td.appendChild(ampm);
   else                          //@06A2
       td.innerHTML = "&nbsp;";

   tr = document.createElement("TR");
   td = document.createElement("TD");
   td.className="wclTimeChooserBottom"; //@04A
   table.appendChild(tfoot);
   tfoot.appendChild(tr);
   tr.appendChild(td);
   td.colSpan = this.showSeconds ? 4 : 3;
   td.alignment = "left";
   td.appendChild(ok);
   td.appendChild(nbsp);
   td.appendChild(cancel);

   return div;
}

function TimeChooser_parseTime(sTime) {
    var timefields = new Array("00", "00", "00", "AM");

    if (sTime != null && sTime.length > 0) {
        var re = /:/g;
        var parms = sTime.replace(re, " ").split(" ");

        if (parms.length > 0)
            timefields[0] = this.formatNumber(parms[0]);

        if (parms.length > 1)
            timefields[1] = this.formatNumber(parms[1]);

        if (parms.length > 2 && this.showSeconds)
            timefields[2] = this.formatNumber(parms[2]);

        if (parms.length > 0 && !this.is24hr)
            timefields[3] = parms[parms.length - 1];
    }

    return timefields;
}

function TimeChooser_formatNumber(number) {
   var anumber = parseInt(number, 10);
   var fnumber = "00" + (isNaN(anumber) ? "" : anumber);

   return fnumber.substring(fnumber.length-2);
}

function TimeChooser_formatTime(timechooser, hours, minutes, seconds, ampm) {
   var time = timechooser.formatNumber(hours) + ":" + timechooser.formatNumber(minutes);

   if (timechooser.showSeconds)
       time += ":" + timechooser.formatNumber(seconds);

   if (!timechooser.is24hr)
       time += " " + ampm;

   return time;
}

function TimeChooser_getTimeChooser(event) {
    var tc = null;
    var tag = getEventTarget(event);
    while (tag != null && tag.tagName != "DIV") {
        tag = tag.parentNode;
        if (tag != null && tag.tagName == "DIV") {
            tc = eval(tag.childNodes[0].value);
            break;
        }
    }
    return tc;
}

function TimeChooser_buttonOkHandler(event) {
    TimeChooser_buttonOutHandler(event);

    var tc = TimeChooser_getTimeChooser(event);
    if (tc != null) {
        // gather time field values
        var doc = getEventTarget(event).ownerDocument;
        var hours = tc.getElementById(tc.makeId("hours"), doc).value;
        var minutes = tc.getElementById(tc.makeId("minutes"), doc).value;
        var seconds = tc.getElementById(tc.makeId("seconds"), doc ).value;
        var ampm = tc.is24hr ? "" : tc.getElementById(tc.makeId("ampm"), doc).value;

        // update the time text field
        var timeInput = tc.getElementById(tc.textID);
        timeInput.value = TimeChooser_formatTime(tc, hours, minutes, seconds, ampm);

        // cancel the dialog
        TimeChooser_buttonCancelHandler(event);
    }
    else
       alert("TimeChooser_buttonOkHandler - null");
}


function TimeChooser_buttonCancelHandler(event) {
    TimeChooser_buttonOutHandler(event);

    var tc = TimeChooser_getTimeChooser(event);
    if (tc != null) {
        tc.hideTimeChooser();

        // set focus on the time button
        var timeButton = tc.getElementById(tc.buttonID);
        timeButton.focus();
    }
    else
       alert("TimeChooser_buttonCancelHandler - null")
}

function TimeChooser_buttonOverHandler(event) {
    var tag = getEventTarget(event);
    if (tag != null) {
        tag.className = "wclButtonMouseOver";
        if (document.all)
            tag.style.height = "100%";
    }
}

function TimeChooser_buttonOutHandler( event ) {
    var tag = getEventTarget(event);
    if (tag != null) {
        tag.className = "wclButton";
        if (document.all)
            tag.style.height = "100%";
    }
}
